using System;
using System.Collections.Generic;
using System.Linq;

using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class PATIENT_IMAGEDB : DBUtils
	{
        private readonly DBBatchOperations DBOps;

        #region Fields
        #endregion

        #region Constructors

        public PATIENT_IMAGEDB()
        {
            DBOps = new DBBatchOperations();
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public PATIENT_IMAGE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_ID)
		{
			PATIENT_IMAGE objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_PATIENT_IMAGE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<PATIENT_IMAGE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<PATIENT_IMAGE> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_PATIENT_IMAGE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, PATIENT_IMAGE objSave)
		{
            int? patientImageId = objSave.PATIENT_IMAGE_ID;

            try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    dbContext.usp_PATIENT_IMAGE_save(
                            CURRENT_USER,
                            CURRENT_REGISTRY_ID,
                            objSave.PATIENT_ID,
                            ref patientImageId,
                            objSave.IMAGE_COUNT,
                            objSave.IS_SENSITIVE,
                            objSave.REPORT_URL,
                            objSave.SOURCE_REFRESH_DATE,
                            objSave.STUDY_DATE,
                            objSave.STUDY_DESCRIPTION,
                            objSave.STUDY_ID,
                            objSave.SYSTEM_IDENTIFIED_FRAGMENT_DATE,
                            objSave.SYSTEM_IDENTIFIED_FRAGMENT_FLAG,
                            objSave.VIEWER_URL);

                    LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return patientImageId.GetValueOrDefault();
		}

        public void Save(string CURRENT_USER, int CURRENT_REGISTRY_ID, int patientId, IEnumerable<STAGING_PATIENT_IMAGE> images)
        {
            try
            {
                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    // Bulk copy images to staging table
                    DBOps.BulkInsert(images, dbContext.Connection, "[EFR].[STAGING_PATIENT_IMAGE]");

                    // Do update/insert of images from staging table
                    dbContext.usp_InsertUpdatePatientImages(CURRENT_USER, CURRENT_REGISTRY_ID, patientId);
                }

                LogManager.LogTiming(logDetails);
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_IMAGE_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_PATIENT_IMAGE_delete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_IMAGE_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public DateTime? GetSourceRefreshDate(string CURRENT_USER, int CURRENT_REGISTRY_ID, int PATIENT_ID)
        {
            SingleDataItem<DateTime?> objReturn;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_GetPatientImageSourceRefreshDate(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).SingleOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn != null ? objReturn.Result : (DateTime?)null;
        }

        #endregion
    }
}
